% Road_creation_1D
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
function [y_l y_r] = Road_creation_1D(road,A, omega, psi_left ,psi_right,graphs)

% Delka cesty (m)
L1 = road.L1;
L2 = road.L2;
L = L2 - L1;
L_car = road.Lcar;

% Pocet vzorku na 1 m cesty
N = road.N;
% Rozdeleni cesty na L * N intervalu
s = road.s;

% Inicializace zvlneni vozovky
y_l = zeros(1,N * L);
y_ll = zeros(1,N * L);
y_r = zeros(1,N * L);
y_rr = zeros(1,N * L);

% Vypocet zvlneni vozovky (eq. 2.17)
for i = 1 : N * L + 1
        
                y_l(i) =sum((A.* sin((omega* s(i)) - psi_left')));               
                y_r(i) =sum((A.* sin((omega* s(i)) - psi_right')));                
    
% progress bar     
     drawnow                
     stopBar = progressbar(i/(N * L),4);
     if (stopBar); break; end
        
end

% Nastaveni pocatecni podminky na 0
%   y(1:N * L) = y(1:N * L) - y(1);
close
%-------------------------------------------------------------------------
if graphs == 1
figure
% x - vzdalenost [m], y - zvlneni [cm]

plot(s,y_l*100,'-b'); hold on
set(gcf,'Color','w');

plot(s,y_r*100,'-r'); hold off
title('Profil cesty');
xlabel('Vzdalenost [m]');
ylabel('Zvlneni povrchu vozovky [cm]');
set(gcf,'Color','w');
legend('leva strana','prava strana');


figure
plot(s,y_l*100,'-b'); hold on
set(gcf,'Color','w');

plot(s+L_car,y_l*100,'-g'); hold off
title('Profil cesty');
xlabel('Vzdalenost [m]');
ylabel('Zvlneni povrchu vozovky [cm]');
set(gcf,'Color','w');
legend('leva strana predni kolo','leva strana zadni kolo');

figure
plot(s,y_r*100,'-b'); hold on
set(gcf,'Color','w');

plot(s+L_car,y_r*100,'-g'); hold off
title('Profil cesty');
xlabel('Vzdalenost [m]');
ylabel('Zvlneni povrchu vozovky [cm]');
set(gcf,'Color','w');
legend('prava strana predni kolo','prava strana zadni kolo');

% axis([0 100 -10 10])
end